/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.event.VWToolbarMouseAdapter;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class VWBaseMapToolbar
extends JMenuBar
implements IVWToolbarActionListener,
ActionListener,
ItemListener {
    protected static final int MAP_NAME = 1;
    protected static final int PARENT_MAP = 4;
    protected static final int ALL = 5;
    protected JComboBox m_mapCombo = null;
    protected AbstractButton m_parentMapButton = null;
    protected VWBaseWorkflowPane m_workflowPane = null;
    protected MouseAdapter m_mouseAdapter = null;
    protected JPopupMenu m_parentMapMenu = null;
    protected String[] m_parentMapNames = null;

    public VWBaseMapToolbar(VWBaseWorkflowPane workflowPane) {
        this.m_workflowPane = workflowPane;
        this.m_mouseAdapter = new VWToolbarMouseAdapter(this, 7, this.m_workflowPane.getToolbarActionNotifier());
        this.addMouseListener(this.m_mouseAdapter);
        this.m_workflowPane.getToolbarActionNotifier().addToolbarActionListener(this);
    }

    public abstract void init();

    public void initMapCombo(Vector maps) {
        try {
            DefaultComboBoxModel<VWMap> cbModel = new DefaultComboBoxModel<VWMap>();
            if (maps != null && maps.size() > 0) {
                Object[] mapArray = new Object[maps.size()];
                maps.copyInto(mapArray);
                VWQubbleSort.sort(mapArray);
                for (int i = 0; i < mapArray.length; ++i) {
                    VWMap map = (VWMap)mapArray[i];
                    if (VWStringUtils.compare(map.getName(), "Workflow") == 0) {
                        cbModel.insertElementAt(map, 0);
                        continue;
                    }
                    cbModel.addElement(map);
                }
            }
            this.m_mapCombo.removeItemListener(this);
            this.m_mapCombo.setModel(cbModel);
            this.m_mapCombo.addItemListener(this);
            if (this.m_mapCombo.getModel().getSize() > 0) {
                this.m_mapCombo.setEnabled(true);
                this.m_mapCombo.setSelectedIndex(0);
            } else {
                this.m_mapCombo.setEnabled(false);
                this.m_mapCombo.setSelectedIndex(-1);
                this.performMapSelectionChanged(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void selectMap(Object map) {
        this.m_mapCombo.setSelectedIndex(-1);
        this.m_mapCombo.setSelectedItem(map);
        this.performMapSelectionChanged(map);
    }

    public void removeReferences() {
        int i;
        this.m_workflowPane = null;
        if (this.m_mapCombo != null) {
            this.m_mapCombo.removeItemListener(this);
            this.m_mapCombo.setRenderer(null);
            this.m_mapCombo.removeAllItems();
            this.m_mapCombo.removeAll();
            this.m_mapCombo = null;
        }
        if (this.m_mouseAdapter != null) {
            this.removeMouseListener(this.m_mouseAdapter);
            if (this.m_mouseAdapter instanceof VWToolbarMouseAdapter) {
                ((VWToolbarMouseAdapter)this.m_mouseAdapter).removeReferences();
            }
            this.m_mouseAdapter = null;
        }
        if (this.m_parentMapButton != null) {
            this.m_parentMapButton.removeActionListener(this);
            this.m_parentMapButton.removeAll();
            this.m_parentMapButton = null;
        }
        if (this.m_parentMapMenu != null) {
            for (i = 0; i < this.m_parentMapMenu.getComponentCount(); ++i) {
                Component comp = this.m_parentMapMenu.getComponent(i);
                if (comp == null || !(comp instanceof JMenuItem)) continue;
                ((JMenuItem)comp).removeActionListener(this);
            }
            this.m_parentMapMenu.removeAll();
            this.m_parentMapMenu = null;
        }
        if (this.m_parentMapNames != null) {
            for (i = 0; i < this.m_parentMapNames.length; ++i) {
                this.m_parentMapNames[i] = null;
            }
            this.m_parentMapNames = null;
        }
        this.removeAll();
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 602: {
                this.performSubmapToolbarAction(true);
                break;
            }
            case 603: {
                this.performSubmapToolbarAction(false);
                break;
            }
            case 503: {
                this.performGotoSubmapAction((String)event.getParam());
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JMenuItem) {
            String selectedMapName = ((JMenuItem)source).getText();
            if (selectedMapName == null) {
                return;
            }
            for (int i = 0; i < this.m_parentMapNames.length; ++i) {
                if (this.m_parentMapNames[i] == null || VWStringUtils.compare(this.m_parentMapNames[i], selectedMapName) != 0) continue;
                this.performGotoSubmapAction(this.m_parentMapNames[i]);
                return;
            }
        } else if (source.equals(this.m_parentMapButton)) {
            this.performParentMap(event);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.m_mapCombo)) {
            this.performMapSelectionChanged(this.m_mapCombo.getSelectedItem());
        }
    }

    protected void init(int flags) {
        try {
            this.setLayout(new BoxLayout(this, 2));
            if ((flags & 1) != 0) {
                this.m_mapCombo = new JComboBox();
                this.m_mapCombo.setName("m_mapCombo_VWBaseMapToolbar");
                this.m_mapCombo.setRenderer(new VWMapListCellRenderer());
                this.m_mapCombo.addItemListener(this);
                this.add(this.m_mapCombo);
                if ((flags & 4) != 0) {
                    this.m_parentMapButton = VWImageLoader.createToolBarButton("parent.gif", VWResource.s_callerMaps, false);
                    this.m_parentMapButton.setName("m_parentMapButton_VWBaseMapToolbar");
                    this.m_parentMapButton.addActionListener(this);
                    this.add(this.m_parentMapButton);
                }
            }
            this.add(Box.createHorizontalStrut(100));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performMapSelectionChanged(Object selectedMap) {
        if (selectedMap != null) {
            this.m_workflowPane.displayMap(selectedMap);
        }
        VWBaseWorkflowMapPane mapPane = null;
        if (this.m_workflowPane != null) {
            mapPane = this.m_workflowPane.getActiveMapPane();
        }
        if (mapPane != null) {
            if (this.m_parentMapNames != null) {
                for (int i = 0; i < this.m_parentMapNames.length; ++i) {
                    this.m_parentMapNames[i] = null;
                }
            }
            this.m_parentMapNames = mapPane.getParentMapNames();
        } else {
            this.m_parentMapNames = null;
        }
        this.updateButtonStates(selectedMap);
    }

    protected void performParentMap(ActionEvent event) {
        if (event.getSource() instanceof AbstractButton) {
            this.m_parentMapNames = null;
            VWBaseWorkflowMapPane mapPane = this.m_workflowPane.getActiveMapPane();
            if (mapPane != null) {
                this.m_parentMapNames = mapPane.getParentMapNames();
            }
            if (this.m_parentMapNames != null && this.m_parentMapNames.length > 0) {
                int i;
                if (this.m_parentMapMenu == null) {
                    this.m_parentMapMenu = new JPopupMenu();
                } else {
                    for (i = 0; i < this.m_parentMapMenu.getComponentCount(); ++i) {
                        Component comp = this.m_parentMapMenu.getComponent(i);
                        if (comp == null || !(comp instanceof JMenuItem)) continue;
                        ((JMenuItem)comp).removeActionListener(this);
                    }
                    this.m_parentMapMenu.removeAll();
                }
                if (this.m_parentMapMenu != null) {
                    for (i = 0; i < this.m_parentMapNames.length; ++i) {
                        if (this.m_parentMapNames[i] == null) continue;
                        JMenuItem mi = new JMenuItem(this.m_parentMapNames[i]);
                        this.m_parentMapMenu.add(mi);
                        mi.addActionListener(this);
                    }
                    this.m_parentMapMenu.show(this.m_parentMapButton, 0, this.m_parentMapButton.getHeight());
                }
            }
        }
    }

    protected void updateButtonStates(Object selectedMap) {
        if (this.m_parentMapButton != null) {
            this.m_parentMapButton.setEnabled(this.m_parentMapNames != null && this.m_parentMapNames.length > 0);
        }
    }

    protected void performSubmapToolbarAction(boolean bShow) {
        this.setVisible(bShow);
    }

    protected void performGotoSubmapAction(String mapName) {
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.m_mapCombo.getModel();
        if (comboBoxModel != null) {
            int size = comboBoxModel.getSize();
            for (int i = 0; i < size; ++i) {
                VWMap map = (VWMap)comboBoxModel.getElementAt(i);
                String name = map.getName();
                if (VWStringUtils.compare(mapName, name) != 0) continue;
                this.selectMap(map);
                break;
            }
        }
    }
}

